;*****************************************************************************************************
;Prog8.asm
;Version vom 23.09.03
;*****************************************************************************************************
	LIST	P = 16f84a

;zuordnung

IND		equ 0			;Operand fr indirekte Adressierung
RTCC		equ 1			;RTCC-Register
PC		equ 2			;Programmzhler
STATUS		equ 3			;Statusregister
FSR		equ 4			;Auswahlregister f. indirektes Adressieren
PORTA		equ 5			;PORTA-Register
PORTB		equ 6			;PORTB-Register
EEDATA          equ 08			;
EEADR           equ 09			;
PCLATH          equ 0A			;
INTCON          equ 0B			;

OPTION_REG      equ 81			;
TRISA           equ 05			;
TRISB           equ 06			;
EECON1          equ 88			;
EECON2          equ 89			;

;----- STATUS Bits --------------------------------------------------------
di		equ 7			; Eingangsbit in EAREG 
do		equ 6			; Ausgangsbit in EAREG 
IRP             equ 7			;
RP1             equ 6			;
RP0             equ 5			;
Z               equ 2			;
DC              equ 1			;
C               equ 0			;

;----- EECON1 Bits --------------------------------------------------------
EEIF            equ 4			;
WRERR           equ 3			;
WREN            equ 2			;
WR              equ 1			;
RD              equ 0			;

;----- INTCON Bits --------------------------------------------------------
GIE		equ 7

Takt		equ 0			;PORTA RA0
Dateneingang	equ 1			;PORTA RA1
Datenausgang	equ 2			;PORTA RA2
Progtaster	equ 3			;PORTA RA3
ProgLED		equ 4			;PORTA RA4 LED

Zhler1		equ 0C			;
Zhler2		equ 0D			;
Zhler3		equ 0E			;
Kanal1		equ 10			;Kanal der 1. Adresse
Kanal2		equ 11			;Kanal der 2. Adresse
Kanal3		equ 12			;Kanal der 3. Adresse
Kanal4		equ 13			;Kanal der 4. Adresse
Kanalzhler	equ 14			;Kanalzhler
Schalter	equ 15			;Byte f. Schalter des Programms
ADpuffer	equ 16			;Speichert im Progmode die neue Adresse
MDpuffer	equ 17			;Speichert im Progmode den neuen Modus
Rpuffer	equ 18			;Speichert im Progmode die neue Rckmeldeadresse
VZpuffer	equ 19			;Speichert im Progmode die Verzgerungszeit
A2puffer	equ 1A			;Speichert im Progmode die zweite Adresse
FUpuffer	equ 1B			;Speichert im Progmode die neuen Funktion
Verzgerung	equ 1C			;Verzgerungszeit des Decoders
EINpuffer	equ 1D			;Puffer f. PortB im Eingang lesen
AUSpuffer	equ 1E			;Puffer f. Daten von Zent. im Ausgabe
Decoderadr	equ 1F			;Adresse des Decoders
Bit0		equ 20			;Verzgerungzhler f. Bit
Bit1		equ 21			;Verzgerungzhler f. Bit
Bit2		equ 22			;Verzgerungzhler f. Bit
Bit3		equ 23			;Verzgerungzhler f. Bit
Bit4		equ 24			;Verzgerungzhler f. Bit
Bit5		equ 25			;Verzgerungzhler f. Bit
Bit6		equ 26			;Verzgerungzhler f. Bit
Bit7		equ 27			;Verzgerungzhler f. Bit
EAREG		equ 28			;Register fuer Ein- und Ausgabe
ZWISCH		equ 29			;Puffer-Register
DATAUSa		equ 2A			;Register fuer Byte-Ausgabe an 259a
DATAUSb		equ 2B			;Register fuer Byte-Ausgabe an 259b
BIT		equ 2C			;Bit-Zaehler
teiladsr	equ 2D			;Zwischenspeicher f. die Teiladresse des PCF
AUSalt		equ 2E			;Daten der letzten Ausgabe
Abit		equ 2F			;1 wenn im letzten Durchgang das Bit gesetzt war
AUSneu		equ 30			;
AusgangA	equ 31			;
AusgangB	equ 32			;
AbitA		equ 33			;1 wenn im letzten Durchgang das Bit gesetzt war
BitA0		equ 34			;Verzgerungzhler f. Bit
BitA1		equ 35			;Verzgerungzhler f. Bit
BitA2		equ 36			;Verzgerungzhler f. Bit
BitA3		equ 37			;Verzgerungzhler f. Bit
BitA4		equ 38			;Verzgerungzhler f. Bit
BitA5		equ 39			;Verzgerungzhler f. Bit
BitA6		equ 3A			;Verzgerungzhler f. Bit
BitA7		equ 3B			;Verzgerungzhler f. Bit
Funktion	equ 3C			;Funktion des Decoders
Decodermodus	equ 3D			;Modus des Decoders
DauerausA	equ 3E			;Speichert die Zustnde der Dauerausgnge in A
Decoderadresse	equ 3F			;Adresse in adw
DauerausB	equ 40			;Speichert die Zustnde der Dauerausgnge in B
Einzaehler	equ 41
ADRESS		equ 42			;zum ermitteln der Aktuellen Adresse des Busses
Rckmeldeadr	equ 43			;Rckmeldeadresse des Decoders
Ausgang		equ 44			;
Eingang		equ 45			;

;Bits in Schalter

Progmode	equ 0			;Schalter f. Programmiermodus
Datenrichtung	equ 1			;Schalter f. die Richtung der Daten 1=lesen 0=schre
Zentrale	equ 2			;Schalter f. Status der Zentrale
Funktionsdec	equ 3			;Schalter 1 = Funktiondecoder 0 = Besetzmelder
DoppelFD	equ 4			;Schalter 1 = 16 Ausgnge 0 = 12 Ausgnge
Ein32		equ 6			;Schalter 1 = 32 Eingnge 0 = 8 Eingnge

;Speicherpltze

Adresspeicher	equ 0			;Speicherplatz der Adresse
Modusspeicher	equ 1			;Speicherplatz des Modus
Rckmeldespei	equ 2			;Speicherplatz der Rckmeldeadresse
Verzgerspei	equ 3			;Speicherplatz der Verzgerungszeit
Funktionspei	equ 5			;Speicherplatz der Funktion
AusgangsspeiA	equ 6			;Speicherplatz des AusgangsA
AusgangsspeiB	equ 7			;Speicherplatz des AusgangsB


;*****************************************************************************************************
		org	0
		goto	init
;*****************************************************************************************************
;Pause von 65536 Durchlufe a 3 Zyklen * 4*0,25 ys bei 4 MHz = 0,196 sek
;*****************************************************************************************************
pause		movlw	.255
		movwf	Zhler1
pausenschleife1	movlw	.255
		movwf	Zhler2
pausenschleife2	decfsz	Zhler2,f
		goto	pausenschleife2
		decfsz	Zhler1,f
		goto	pausenschleife1
		retlw	0
;*****************************************************************************************************
;Datenbermittlung
;*****************************************************************************************************
adw		movlw	.255			;Lesespeicher der Adresse m. 1 fllen da die
		movwf	ADRESS			;Adresse 4 Bit lang und invertiert ist
		movlw	03			;Zhler mit der Anzahl
		movwf	Zhler1			;der Sync 0 laden
		movlw	b'00010000'		;PortA
		andwf	PORTA,f			;bis auf RA4 lschen
		bsf	STATUS,RP0		;Seite 1
		movlw	b'01111'		;RA0,RA1,RA2 & 
		movwf	TRISA			;RA3 Eingang, RA4 Ausgang
		bcf	STATUS,RP0		;Seite 0
		btfsc	Schalter,Zentrale	;wenn die Zentrale aus ist den Progtaster abfragen
		goto	Syncronkanal		;ansonsten Zentrale auslesen
		btfsc	PORTA,Progtaster	;Progtaster abfragen
		bsf	Schalter,Progmode	;wenn ja Progschalter ein
Syncronkanal	call	TaktLow			;abfragen ob Taktwechsel
		btfsc	PORTA,Dateneingang	;Wenn Daten 0 zhle die Nullen
		goto	adw			;sonst von vorne
		decfsz	Zhler1,f			;Nullen zhlen, wenn 3 dann warte auf Daten
		goto	Syncronkanal		;ansonsten nchste Null
		call 	TaktLow			;abfragen ob Taktwechsel, fr Trenn High
		call	TaktLow			;abfragen ob Taktwechsel, fr Trenn High
		btfsc	PORTA,Dateneingang	;wenn Zentrale ein
		bsf	Schalter,Zentrale	;Schalter Zentrale ein
		btfss	PORTA,Dateneingang	;wenn Zentrale aus
		bcf	Schalter,Zentrale	;Schalter Zentrale aus
		call	TaktLow			;abfragen ob Taktwechsel, fr Trenn High
		call	TaktLow			;abfragen ob Taktwechsel

;;;;	Adresse die gerade von der Zentrale kommt lesen und mit der gespeicherten vergleichen

		bcf	STATUS,C		;Carry Bit lschen
		btfsc	PORTA,Dateneingang	;wenn der Dateneingang High ist
		goto	setzen1			;dann gehe zum Setzen
		bcf	ADRESS,0		;wenn der Dateneingang Low ist
		goto	weiter1			;gleich zum nchsten Bit
setzen1		bsf	ADRESS,0		;setze Bit 0 in Adresse
weiter1		rlf	ADRESS,f		;schiebe Adresse links
		call	TaktLow			;abfragen ob Taktwechsel
		btfsc	PORTA,Dateneingang	;wenn der Dateneingang High ist
		goto	setzen2			;dann gehe zum setzen
		bcf	ADRESS,0		;wenn der Dateneingang Low ist
		goto	weiter2			;gleich zum nchsten Bit
setzen2		bsf	ADRESS,0		;setze Bit 0 in Adresse
weiter2		rlf	ADRESS,f		;schiebe Adresse links
		call	TaktLow			;abfragen ob Taktwechsel, fr Trenn High
		call	TaktLow			;abfragen ob Taktwechsel
		bcf	STATUS,C		;Carry Bit lschen
		btfsc	PORTA,Dateneingang	;wenn der Dateneingang High ist
		goto	setzen3			;dann gehe zum setzen
		bcf	ADRESS,0		;wenn der Dateneingang Low ist
		goto	weiter3			;gleich zum nchsten Bit
setzen3		bsf	ADRESS,0		;setze Bit 0 in Adresse
weiter3		rlf	ADRESS,f		;schiebe Adresse links
		call	TaktLow			;abfragen ob Taktwechsel
		bcf	STATUS,C		;Carry Bit lschen
		btfsc	PORTA,Dateneingang	;wenn der Dateneingang High ist
		goto	setzen4			;dann gehe zum setzen
		bcf	ADRESS,0		;wenn der Dateneingang Low ist
		goto	weiter4			;gleich zum nchsten Bit
setzen4		bsf	ADRESS,0		;setze Bit 0 in Adresse
weiter4		comf	ADRESS,f		;invertiere Adresse, da diese invertiert von der Zentrale kommt
		movf	ADRESS,w		;gespeicherte Adresse minus der
		subwf	Decoderadresse,w	;Adresse von der Zentrale
		btfss	STATUS,Z		;wenn das Ergebniss 0 ist stimmt die aktuelle
		goto	adw			;Adresse, sonst beginne von vorne
		call	TaktLow			;abfragen ob Taktwechsel, fr TrennHigh
wdd		decfsz	Kanalzhler,f		;gespeicherter Kanal minus 1 wenn
		goto	wnr			;nicht null Kanal durchlaufen
		goto	datenaustausch		;Kanal stimmt berein gehe zum Datenaustausch
wnr		movlw	.12			;einen Kanal durchlaufen, Anzahl der
		movwf	Zhler1			;Bits in einem Kanal in den Zhler laden
wnr1		call	TaktLow			;abfragen ob Taktwechsel
		decfsz	Zhler1,f			;bei jedem Taktwechsel(Bit) Zhler minus 1
		goto	wnr1			;wenn nicht null nchstes Bit im Kanal
		goto	wdd			;Kanal durchlaufen, zum nchsten Kanal

datenaustausch	btfss	Schalter,Datenrichtung	;wenn der Schalter der Datenrichtung
		call	Datenschreiben		;gesetzt ist dann berspringe Daten schreiben
		btfsc	Schalter,Datenrichtung	;wenn der Schalter der Datenrichtung nicht
		call	Datenlesen		;gesetzt ist dann berspringe Daten lesen
		return
;*****************************************************************************************************
;Daten von der Zentrale lesen
;*****************************************************************************************************
Datenlesen	movlw	.4
		movwf	Zhler1
lesen		movlw	.2
		movwf	Zhler2
		bcf	STATUS,C	
lesen1		call	TaktLow			;abfragen ob Taktwechsel
		btfsc	PORTA,Dateneingang	;Daten lesen
		goto	set1
		bcf	Ausgang,7
		goto	cl1			
set1		bsf	Ausgang,7
cl1		rrf	Ausgang,f
		decfsz	Zhler2,f
		goto	lesen1
		call	TaktLow			;abfragen ob Taktwechsel
		decfsz	Zhler1,f
		goto	lesen
		rlf	Ausgang,f
		return
;*****************************************************************************************************
;Daten zur Zentrale schreiben
;*****************************************************************************************************
Datenschreiben	btfsc	Schalter,Progmode	;wenn Progmode auf jeden Fall schreiben
		goto	Schreibenstart		;
		btfsc	Schalter,Funktionsdec
		goto	Schreibenstart
		btfss	Schalter,Zentrale
		return
Schreibenstart	bsf	STATUS,RP0	
		movlw	b'01011'		;
		movwf	TRISA			;RA0, RA1 , RA2 und RA3 Eingang
		bcf	STATUS,RP0
		movlw	.4
		movwf	Zhler1
		bcf	STATUS,C	
lesen11		call	TaktLow			;abfragen ob Taktwechsel
		btfsc	Eingang,0	
		goto	set11
		bcf	PORTA,Datenausgang
		goto	cl11			
set11		bsf	PORTA,Datenausgang
cl11		rrf	Eingang,f
		call	TaktLow			;abfragen ob Taktwechsel
		btfsc	Eingang,0		;Daten lesen
		goto	set21
		bcf	PORTA,Datenausgang
		goto	cl21			
set21		bsf	PORTA,Datenausgang
cl21		rrf	Eingang,f
		call	TaktLow			;abfragen ob Taktwechsel
		decfsz	Zhler1,f
		goto	lesen11
		rrf	Eingang,f
		bsf	STATUS,RP0	
		movlw	b'01111'		;
		movwf	TRISA			;RA0, RA1 , RA2 und RA3 Eingang
		bcf	STATUS,RP0
		return
;*****************************************************************************************************
;Taktwechsel abwarten
;*****************************************************************************************************
TaktLow		btfsc	PORTA,Takt		;wenn Takt Low
		goto	TaktLow	
TaktHigh	btfss	PORTA,Takt		;wenn Takt High
		goto	TaktHigh
		return
;*****************************************************************************************************
;Daten an den PortB ausgeben
;*****************************************************************************************************
Ausgabe		movf	Ausgang,w		;Neuer Ausgang in den Akku
		andwf	Decodermodus,w
		movwf	DauerausA

		comf	Ausgang,w
		andwf	Decodermodus,w
		movwf	DauerausB
	
		movf	Ausgang,w		;Neuer Ausgang in den Akku
		movwf	AUSneu			;Neuer Ausgang in AUSneu
		comf	Ausgang,w		;Ausgang invertieren
		andwf	AusgangA,w		;in AusgangA alter Ausgang, nur neue Impulse im Akku lassen
		movwf	AUSpuffer		;nur neue Impulse werden in AUSpuffer gespeichert
		movf	AUSneu,w		;aktueller Ausgang
		movwf	AusgangA		;in AusgangA als alt fr nchsten Zyklus speichern
		call	Ausgabe0A		;Impulsdaueraufbereitung

		movf	Ausgang,w		;Momentimpulse mit
		iorwf	DauerausA,w		;den Dauerausgngen verknpfen
		movwf	DATAUSa			;Ergebniss im Ausgabespeicher

		comf	DauerausB,w
		andwf	DATAUSa,f

		comf	AusgangB,f
		movf	AUSneu,w
		movwf	Ausgang
		andwf	AusgangB,w		;nur neue Impulse im Akku lassen
		movwf	AUSpuffer		;nur neue Impulse werden in AUSpuffer gespeichert
		movf	Ausgang,w		;Neuer Ausgang in den Akku
		movwf	AusgangB		;Neuer Ausgang in AUSalt fr nchsten Zyklus
		call	Ausgabe0B

		movf	Ausgang,w
		iorwf	DauerausB,w
		movwf	DATAUSb
		comf	DauerausA,w
		andwf	DATAUSb,f

		call	ausgabe259B
		call	ausgabe259A

		bcf	STATUS,RP0
berspr		movlw	AusgangsspeiA
		movwf	EEADR
		movf	AUSneu,w
		movwf	EEDATA
		call	EEschre
		movf	AUSneu,w		;??????
		movwf	Eingang			;??????
		return
;*****************************************************************************************************
;Daten an 74LS259 A ausgeben
;*****************************************************************************************************
ausgabe259A	bsf	STATUS,RP0		;
		movlw	b'10100000'		;RB 0-4 & 6 = Ausgaenge
		movwf	TRISB			;
		bcf	STATUS,RP0		;
		movlw	07
		movwf	Zhler1			;Vorbereiten fuer 7+1 Datenbits
Schleife259A	movf	Zhler1,w			;Zhler ist zu Beginn 7
		iorlw	b'01000000'		;Clear auf High
		movwf	PORTB			;Adresse (LS259) und Lschbit an PortB
		btfsc	DATAUSa,7		;wenn Bit7 in DATAUSa gesetzt
		goto	setze259A1		;
		bcf	PORTB,3			;lsche Bit 3 PortB (D LS259)
		goto	ber259A1		;
setze259A1	bsf	PORTB,3			;setze Bit 3 PortB (D LS259)
ber259A1	bcf	PORTB,4			;lsche Bit 4 PortB (EN LS259)
		bsf	PORTB,4			;setze Bit 4 PortB (EN LS259)
		rlf	DATAUSa,f		;DATAUSa links rotieren (da bit 7 gelesen wird,
		decfsz	Zhler1,f			;kann Carry nicht stoeren)
		goto	Schleife259A		;Schleife 8 mal durchlaufen
		movlw	b'01000000'		;Clear auf High Adresse 0
		movwf	PORTB			;Adresse (LS259) und Lschbit an PortB
		btfsc	DATAUSa,7		;wenn Bit7 in DATAUSa gesetzt
		goto	setze259A2
		bcf	PORTB,3			;lsche Bit 3 PortB (D LS259)
		goto	ber259A2
setze259A2	bsf	PORTB,3			;setze Bit 3 PortB (D LS259)
ber259A2	bcf	PORTB,4			;lsche Bit 4 PortB (EN LS259)
		bsf	PORTB,4			;setze Bit 4 PortB (EN LS259)
		return
;*****************************************************************************************************
;Daten an 74LS259 B ausgeben
;*****************************************************************************************************
ausgabe259B	bsf	STATUS,RP0
		movlw	b'10010000'		;RB 0-3 & 5-6 = Ausgaenge
		movwf	TRISB
		bcf	STATUS,RP0
		movlw	07
		movwf	Zhler1			;Vorbereiten fuer 7+1 Datenbits
Schleife259B	movf	Zhler1,w
		iorlw	b'01000000'		;Clear auf High
		movwf	PORTB
		btfsc	DATAUSb,7		;bit 0-6 von DATAUSb ausgeben
		goto	setze259B1
		bcf	PORTB,3
		goto	ber259B1
setze259B1	bsf	PORTB,3
ber259B1	bcf	PORTB,5
		bsf	PORTB,5
		rlf	DATAUSb,f		;DATAUSb links rotieren (da bit 7 gelesen wird,
		decfsz	Zhler1,f			;kann Carry nicht stoeren)
		goto	Schleife259B		;Schleife 8 mal durchlaufen
		movlw	b'01000000'		;Clear auf High
		movwf	PORTB
		btfsc	DATAUSb,7		;bit 7 von DATAUSb ausgeben
		goto	setze259B2
		bcf	PORTB,3
		goto	ber259B2
setze259B2	bsf	PORTB,3
ber259B2	bcf	PORTB,5
		bsf	PORTB,5
		return
;*****************************************************************************************************
;Daten fr den 74LS259 A aufbereiten
;*****************************************************************************************************
Ausgabe0A	btfsc	AUSpuffer,0		;wenn bit 0 nicht gesetzt berspringe
		goto	aussetzen0A		;wenn bit 0 gesetzt Ausgang,0 setzen
		btfss	AbitA,0			;wenn Ausgang,0 gesetzt berspringe
		goto	auslschen0A		;wenn Ausgang,0 nicht ndern
		decfsz	BitA0,f
		goto	aussetzen00A
auslschen0A	bcf	Ausgang,0
		bcf	AbitA,0
		goto	Ausgabe1A	
aussetzen0A	movf	Verzgerung,w
		movwf	BitA0
		bcf	Abit,0
		bsf	AbitA,0
aussetzen00A	bsf	Ausgang,0

Ausgabe1A	btfsc	AUSpuffer,1		;wenn bit 0 nicht gesetzt berspringe
		goto	aussetzen1A		;wenn bit 0 gesetzt Ausgang,0 setzen
		btfss	AbitA,1			;wenn Ausgang,0 gesetzt berspringe
		goto	auslschen1A		;wenn Ausgang,0 nicht ndern
		decfsz	BitA1,f
		goto	aussetzen01A
auslschen1A	bcf	Ausgang,1
		bcf	AbitA,1
		goto	Ausgabe2A	
aussetzen1A	movf	Verzgerung,w
		movwf	BitA1
		bcf	Abit,1
		bsf	AbitA,1
aussetzen01A	bsf	Ausgang,1

Ausgabe2A	btfsc	AUSpuffer,2		;wenn bit 0 nicht gesetzt berspringe
		goto	aussetzen2A		;wenn bit 0 gesetzt Ausgang,0 setzen
		btfss	AbitA,2			;wenn Ausgang,0 gesetzt berspringe
		goto	auslschen2A		;wenn Ausgang,0 nicht ndern
		decfsz	BitA2,f
		goto	aussetzen02A
auslschen2A	bcf	Ausgang,2
		bcf	AbitA,2
		goto	Ausgabe3A	
aussetzen2A	movf	Verzgerung,w
		movwf	BitA2
		bcf	Abit,2
		bsf	AbitA,2
aussetzen02A	bsf	Ausgang,2

Ausgabe3A	btfsc	AUSpuffer,3		;wenn bit 0 nicht gesetzt berspringe
		goto	aussetzen3A		;wenn bit 0 gesetzt Ausgang,0 setzen
		btfss	AbitA,3			;wenn Ausgang,0 gesetzt berspringe
		goto	auslschen3A		;wenn Ausgang,0 nicht ndern
		decfsz	BitA3,f
		goto	aussetzen03A
auslschen3A	bcf	Ausgang,3
		bcf	AbitA,3
		goto	Ausgabe4A	
aussetzen3A	movf	Verzgerung,w
		movwf	BitA3
		bcf	Abit,3
		bsf	AbitA,3
aussetzen03A	bsf	Ausgang,3

Ausgabe4A	btfsc	AUSpuffer,4		;wenn bit 0 nicht gesetzt berspringe
		goto	aussetzen4A		;wenn bit 0 gesetzt Ausgang,0 setzen
		btfss	AbitA,4			;wenn Ausgang,0 gesetzt berspringe
		goto	auslschen4A		;wenn Ausgang,0 nicht ndern
		decfsz	BitA4,f
		goto	aussetzen04A
auslschen4A	bcf	Ausgang,4
		bcf	AbitA,4
		goto	Ausgabe5A	
aussetzen4A	movf	Verzgerung,w
		movwf	BitA4
		bcf	Abit,4
		bsf	AbitA,4
aussetzen04A	bsf	Ausgang,4

Ausgabe5A	btfsc	AUSpuffer,5		;wenn bit 0 nicht gesetzt berspringe
		goto	aussetzen5A		;wenn bit 0 gesetzt Ausgang,0 setzen
		btfss	AbitA,5			;wenn Ausgang,0 gesetzt berspringe
		goto	auslschen5A		;wenn Ausgang,0 nicht ndern
		decfsz	BitA5,f
		goto	aussetzen05A
auslschen5A	bcf	Ausgang,5
		bcf	AbitA,5
		goto	Ausgabe6A	
aussetzen5A	movf	Verzgerung,w
		movwf	BitA5
		bcf	Abit,5
		bsf	AbitA,5
aussetzen05A	bsf	Ausgang,5

Ausgabe6A	btfsc	AUSpuffer,6		;wenn bit 0 nicht gesetzt berspringe
		goto	aussetzen6A		;wenn bit 0 gesetzt Ausgang,0 setzen
		btfss	AbitA,6			;wenn Ausgang,0 gesetzt berspringe
		goto	auslschen6A		;wenn Ausgang,0 nicht ndern
		decfsz	BitA6,f
		goto	aussetzen06A
auslschen6A	bcf	Ausgang,6
		bcf	AbitA,6
		goto	Ausgabe7A	
aussetzen6A	movf	Verzgerung,w
		movwf	BitA6
		bcf	Abit,6
		bsf	AbitA,6
aussetzen06A	bsf	Ausgang,6

Ausgabe7A	btfsc	AUSpuffer,7		;wenn bit 0 nicht gesetzt berspringe
		goto	aussetzen7A		;wenn bit 0 gesetzt Ausgang,0 setzen
		btfss	AbitA,7			;wenn Ausgang,0 gesetzt berspringe
		goto	auslschen7A		;wenn Ausgang,0 nicht ndern
		decfsz	BitA7,f
		goto	aussetzen07A
auslschen7A	bcf	Ausgang,7
		bcf	AbitA,7
		goto	Ausgabe8A	
aussetzen7A	movf	Verzgerung,w
		movwf	BitA7
		bcf	Abit,7
		bsf	AbitA,7
aussetzen07A	bsf	Ausgang,7
Ausgabe8A	return
;*****************************************************************************************************
;Daten fr den 74LS259 B aufbereiten aufbereiten
;*****************************************************************************************************
Ausgabe0B	btfsc	AUSpuffer,0		;wenn bit 0 nicht gesetzt berspringe
		goto	aussetzen0B		;wenn bit 0 gesetzt Ausgang,0 setzen
		btfss	Abit,0			;wenn Ausgang,0 gesetzt berspringe
		goto	auslschen0B		;wenn Ausgang,0 nicht ndern
		decfsz	Bit0,f
		goto	aussetzen00B
auslschen0B	bcf	Ausgang,0
		bcf	Abit,0
		goto	Ausgabe1B	
aussetzen0B	movf	Verzgerung,w
		movwf	Bit0
		bcf	AbitA,0
		bsf	Abit,0
aussetzen00B	bsf	Ausgang,0

Ausgabe1B	btfsc	AUSpuffer,1		;wenn bit 0 nicht gesetzt berspringe
		goto	aussetzen1B		;wenn bit 0 gesetzt Ausgang,0 setzen
		btfss	Abit,1			;wenn Ausgang,0 gesetzt berspringe
		goto	auslschen1B		;wenn Ausgang,0 nicht ndern
		decfsz	Bit1,f
		goto	aussetzen01B
auslschen1B	bcf	Ausgang,1
		bcf	Abit,1
		goto	Ausgabe2B	
aussetzen1B	movf	Verzgerung,w
		movwf	Bit1
		bcf	AbitA,1
		bsf	Abit,1
aussetzen01B	bsf	Ausgang,1

Ausgabe2B	btfsc	AUSpuffer,2		;wenn bit 2 nicht gesetzt berspringe
		goto	aussetzen2B		;wenn bit 2 gesetzt Ausgang,2 setzen
		btfss	Abit,2			;wenn Ausgang,0 gesetzt berspringe
		goto	auslschen2B		;wenn Ausgang,0 nicht ndern
		decfsz	Bit2,f
		goto	aussetzen02B
auslschen2B	bcf	Ausgang,2
		bcf	Abit,2
		goto	Ausgabe3B	
aussetzen2B	movf	Verzgerung,w
		movwf	Bit2
		bcf	AbitA,2
		bsf	Abit,2
aussetzen02B	bsf	Ausgang,2

Ausgabe3B	btfsc	AUSpuffer,3		;wenn bit 0 nicht gesetzt berspringe
		goto	aussetzen3B		;wenn bit 0 gesetzt Ausgang,0 setzen
		btfss	Abit,3			;wenn Ausgang,0 gesetzt berspringe
		goto	auslschen3B		;wenn Ausgang,0 nicht ndern
		decfsz	Bit3,f
		goto	aussetzen03B
auslschen3B	bcf	Ausgang,3
		bcf	Abit,3
		goto	Ausgabe4B	
aussetzen3B	movf	Verzgerung,w
		movwf	Bit3
		bcf	AbitA,3
		bsf	Abit,3
aussetzen03B	bsf	Ausgang,3

Ausgabe4B	btfsc	AUSpuffer,4		;wenn bit 0 nicht gesetzt berspringe
		goto	aussetzen4B		;wenn bit 0 gesetzt Ausgang,0 setzen
		btfss	Abit,4			;wenn Ausgang,0 gesetzt berspringe
		goto	auslschen4B		;wenn Ausgang,0 nicht ndern
		decfsz	Bit4,f
		goto	aussetzen04B
auslschen4B	bcf	Ausgang,4
		bcf	Abit,4
		goto	Ausgabe5B	
aussetzen4B	movf	Verzgerung,w
		movwf	Bit4
		bcf	AbitA,4
		bsf	Abit,4
aussetzen04B	bsf	Ausgang,4

Ausgabe5B	btfsc	AUSpuffer,5		;wenn bit 0 nicht gesetzt berspringe
		goto	aussetzen5B		;wenn bit 0 gesetzt Ausgang,0 setzen
		btfss	Abit,5			;wenn Ausgang,0 gesetzt berspringe
		goto	auslschen5B		;wenn Ausgang,0 nicht ndern
		decfsz	Bit5,f
		goto	aussetzen05B
auslschen5B	bcf	Ausgang,5
		bcf	Abit,5
		goto	Ausgabe6B	
aussetzen5B	movf	Verzgerung,w
		movwf	Bit5
		bcf	AbitA,5
		bsf	Abit,5
aussetzen05B	bsf	Ausgang,5

Ausgabe6B	btfsc	AUSpuffer,6		;wenn bit 0 nicht gesetzt berspringe
		goto	aussetzen6B		;wenn bit 0 gesetzt Ausgang,0 setzen
		btfss	Abit,6			;wenn Ausgang,0 gesetzt berspringe
		goto	auslschen6B		;wenn Ausgang,0 nicht ndern
		decfsz	Bit6,f
		goto	aussetzen06B
auslschen6B	bcf	Ausgang,6
		bcf	Abit,6
		goto	Ausgabe7B	
aussetzen6B	movf	Verzgerung,w
		movwf	Bit6
		bcf	AbitA,6
		bsf	Abit,6
aussetzen06B	bsf	Ausgang,6

Ausgabe7B	btfsc	AUSpuffer,7		;wenn bit 0 nicht gesetzt berspringe
		goto	aussetzen7B		;wenn bit 0 gesetzt Ausgang,0 setzen
		btfss	Abit,7			;wenn Ausgang,0 gesetzt berspringe
		goto	auslschen7B		;wenn Ausgang,0 nicht ndern
		decfsz	Bit7,f
		goto	aussetzen07B
auslschen7B	bcf	Ausgang,7
		bcf	Abit,7
		goto	Ausgabe8B	
aussetzen7B	movf	Verzgerung,w
		movwf	Bit7
		bcf	AbitA,7
		bsf	Abit,7
aussetzen07B	bsf	Ausgang,7
Ausgabe8B	return
;*****************************************************************************************************
;Daten von PortB lesen
;*****************************************************************************************************
Eingabe		movf	PORTB,w
		movwf	EINpuffer
Eingabe0	btfsc	EINpuffer,0		;wenn RB0 nicht gesetzt berspringe
		goto	einsetzen0		;wenn RB0 gesetzt Eingang,0 setzen
		btfss	Eingang,0		;wenn Eingang,0 gesetzt berspringe
		goto	Eingabe1		;wenn Eingang,0 nicht ndern
		decfsz	Bit0,f
		goto	einsetzen00
		bcf	Eingang,0
		goto	Eingabe1	
einsetzen0	movf	Verzgerung,w
		movwf	Bit0
einsetzen00	bsf	Eingang,0
Eingabe1	btfsc	EINpuffer,1		;wenn RB1 nicht gesetzt berspringe
		goto	einsetzen1		;wenn RB1 gesetzt Eingang,1 setzen
		btfss	Eingang,1		;wenn Eingang,1 gesetzt berspringe
		goto	Eingabe2		;wenn Eingang,1 nicht ndern
		decfsz	Bit1,f
		goto	einsetzen10
		bcf	Eingang,1
		goto	Eingabe2	
einsetzen1	movf	Verzgerung,w
		movwf	Bit1
einsetzen10	bsf	Eingang,1
Eingabe2	btfsc	EINpuffer,2		;wenn RBx nicht gesetzt berspringe
		goto	einsetzen2		;wenn RBx gesetzt Eingang,x setzen
		btfss	Eingang,2		;wenn Eingang,x gesetzt berspringe
		goto	Eingabe3		;wenn Eingang,x nicht ndern
		decfsz	Bit2,f
		goto	einsetzen20
		bcf	Eingang,2
		goto	Eingabe3	
einsetzen2	movf	Verzgerung,w
		movwf	Bit2
einsetzen20	bsf	Eingang,2
Eingabe3	btfsc	EINpuffer,3		;wenn RBx nicht gesetzt berspringe
		goto	einsetzen3		;wenn RBx gesetzt Eingang,x setzen
		btfss	Eingang,3		;wenn Eingang,x gesetzt berspringe
		goto	Eingabe4		;;wenn Eingang,x nicht ndern
		decfsz	Bit3,f
		goto	einsetzen30
		bcf	Eingang,3
		goto	Eingabe4	
einsetzen3	movf	Verzgerung,w
		movwf	Bit3
einsetzen30	bsf	Eingang,3
Eingabe4	btfsc	EINpuffer,4		;wenn RBx nicht gesetzt berspringe
		goto	einsetzen4		;wenn RBx gesetzt Eingang,x setzen
		btfss	Eingang,4		;wenn Eingang,x gesetzt berspringe
		goto	Eingabe5		;wenn Eingang,x nicht ndern
		decfsz	Bit4,f
		goto	einsetzen40
		bcf	Eingang,4
		goto	Eingabe5	
einsetzen4	movf	Verzgerung,w
		movwf	Bit4
einsetzen40	bsf	Eingang,4
Eingabe5	btfsc	EINpuffer,5		;wenn RBx nicht gesetzt berspringe
		goto	einsetzen5		;wenn RBx gesetzt Eingang,x setzen
		btfss	Eingang,5		;wenn Eingang,x gesetzt berspringe
		goto	Eingabe6		;wenn Eingang,x nicht ndern
		decfsz	Bit5,f
		goto	einsetzen50
		bcf	Eingang,5
		goto	Eingabe6	
einsetzen5	movf	Verzgerung,w
		movwf	Bit5
einsetzen50	bsf	Eingang,5
Eingabe6	btfsc	EINpuffer,6		;wenn RBx nicht gesetzt berspringe
		goto	einsetzen6		;wenn RBx gesetzt Eingang,x setzen
		btfss	Eingang,6		;wenn Eingang,x gesetzt berspringe
		goto	Eingabe7		;wenn Eingang,x nicht ndern
		decfsz	Bit6,f
		goto	einsetzen60
		bcf	Eingang,6
		goto	Eingabe7	
einsetzen6	movf	Verzgerung,w
		movwf	Bit6
einsetzen60	bsf	Eingang,6
Eingabe7	btfsc	EINpuffer,7		;wenn RBx nicht gesetzt berspringe
		goto	einsetzen7		;wenn RBx gesetzt Eingang,x setzen
		btfss	Eingang,7		;wenn Eingang,x gesetzt berspringe
		goto	Eingabe8		;wenn Eingang,x nicht ndern
		decfsz	Bit7,f
		goto	einsetzen70
		bcf	Eingang,7
		goto	Eingabe8	
einsetzen7	movf	Verzgerung,w
		movwf	Bit7
einsetzen70	bsf	Eingang,7
Eingabe8	return
;*****************************************************************************************************
;Daten vom 74LS251 A lesen
;*****************************************************************************************************
ein4fach	bsf	STATUS,RP0		;
		movlw	b'00001000'		;RB 0-2 & 4-7 = Ausgaenge
		movwf	TRISB			;
		bcf	STATUS,RP0		;
		movlw	07
		movwf	Zhler1			;Vorbereiten fuer 7+1 Datenbits
Schleife251A	movf	Zhler1,w
		iorlw	b'11110000'
		andwf	Einzaehler,w
		movwf	PORTB	
		btfsc	PORTB,3			;wenn Datenbit gesetzt 
		goto	setze251A1		;
		bcf	Eingang,0		;
		goto	ber251A1		;
setze251A1	bsf	Eingang,0		;
ber251A1	rlf	Eingang,f		;Eingang links rotieren (da bit 7 geschrieben wird,
		decfsz	Zhler1,f			;kann Carry nicht stoeren)
		goto	Schleife251A		;Schleife 8 mal durchlaufen
		movlw	b'11110000'
		andwf	Einzaehler,w
		movwf	PORTB
		btfsc	PORTB,3			;wenn Datenbit gesetzt
		goto	setze251A2
		bcf	Eingang,0
		goto	ber251A2
setze251A2	bsf	Eingang,0
ber251A2	return
;*****************************************************************************************************
;EEprom Daten Schreiben
;*****************************************************************************************************	
EEschre		bsf	STATUS,RP0
		bsf	EECON1,WREN
		bcf	INTCON,GIE
		MOVLW	055
		MOVWF	EECON2
		MOVLW	0AA
		movwf	EECON2
		bsf	EECON1,WR

		bsf	INTCON,GIE
		bcf	EECON1,WREN
		;bcf	EECON1,EEIF
		bcf	STATUS,RP0
		return
;*****************************************************************************************************
;EEprom Daten lesen
;*****************************************************************************************************
EElesen		bsf	STATUS,RP0
		bsf	EECON1,RD
		bcf	STATUS,RP0
		nop
		movf	EEDATA,w
		return
;*****************************************************************************************************
;Decoder programmieren
;*****************************************************************************************************
Programmieren	bcf	PORTA,ProgLED		;lsche die ProgLED
		btfsc	PORTA,Progtaster	;wenn die Progtaste nicht gedrckt ist gehe weiter
		goto	Programmieren		;wenn die Progtaste gedrckt ist gehe zurck

;;;;	Decoderwerte zur Zentrale senden			

		movlw	1B			;erstes Register fr
		movwf	FSR			;fr die indirekte Adressierung in FSR laden
		movlw	.6			;Zhler mit der Anzahl der Werte +1 da Schleife bei 1
		movwf	Zhler3			;beendet wird laden die zur Zentrale gesendet werden
Dwerteschreiben	movf	Zhler3,w		;Zhler der Werte in die
		movwf	Decoderadresse		;Decoderadresse laden
		decf	Decoderadresse,f	;Zhler minus 1
		movlw	.7			;ersten Kanal
		movwf	Kanalzhler		;in den Kanalzhler laden
		movf	IND,w			;indirekte Adressierung Register aus FSR wird in
		movwf	Eingang			;den Eingang geladen
		bcf	Schalter,Datenrichtung	;auf Daten schreiben schalten
		call	adw			;Daten schreiben
		decf	FSR,f			;FSR minus 1 also nchstes Register
		decfsz	Zhler3,f		;Zhler der Werte minus 1, wenn 0 dann Schleifenende
		goto	Dwerteschreiben		;wenn Zhler der Werte nicht 0 dann nchster Wert

;;;;	Warten bis die Zentrale aus ist

Zentraleaus	movlw	.00			;die Adresse ist egal, da nur der Zustand der Zentrale
		movwf	Decoderadresse		;geprft wird, also lade Decoderadresse mit Adresse 0
		movlw	.7			;ersten Kanal
		movwf	Kanalzhler		;in den Kanalzhler laden
		bsf	Schalter,Datenrichtung	;auf Daten lesen schalten
		call	adw			;Daten lesen
		btfsc	Schalter,Zentrale	;wenn die Zentrale aus ist Schleifenende
		goto	Zentraleaus		;sonst erneut lesen

adresschleife	movlw	1B			;
		movwf	FSR			;
		movlw	.6			;
		movwf	Zhler3			;

Dwertelesen	movf	Zhler3,w		;
		movwf	Decoderadresse		;
		decf	Decoderadresse,f	;Zhler minus 1
		movlw	.7			;
		movwf	Kanalzhler		;
		bsf	Schalter,Datenrichtung	;auf Daten lesen schalten
		call	adw			;Daten lesen
		movf	Ausgang,w		;
		movwf	IND			;
		decf	FSR,f			;
		decfsz	Zhler3,f		;
		goto	Dwertelesen		;


		btfsc	Schalter,Zentrale	;
		goto	programmierende		;
		btfss	PORTA,Progtaster	;wenn Progtaste gedrckt Progende		
		goto	adresschleife		;
		
programmierende	bcf	STATUS,RP0		;wenn Progende Neue Adresse speichern
		movlw	Adresspeicher		;
		movwf	EEADR			;
		movf	ADpuffer,w		;
		movwf	EEDATA			;
		call	EEschre			;
		call	pause			;

		bcf	STATUS,RP0		;wenn Progende neuen Modus speichern
		movlw	Modusspeicher		;
		movwf	EEADR
		movf	MDpuffer,w
		movwf	EEDATA
		call	EEschre
		call	pause

		bcf	STATUS,RP0		;wenn Progende neue Rckmeldeadresse
		movlw	Rckmeldespei		;speichern
		movwf	EEADR
		movf	Rpuffer,w
		movwf	EEDATA
		call	EEschre
		call	pause

		bcf	STATUS,RP0		;wenn Progende neue Verzgerungszeit
		movlw	Verzgerspei		;speichern
		movwf	EEADR
		movf	VZpuffer,w
		movwf	EEDATA
		call	EEschre
		call	pause

		bcf	STATUS,RP0		;wenn Progende neue Verzgerungszeit
		movlw	Funktionspei		;speichern
		movwf	EEADR
		movf	FUpuffer,w
		movwf	EEDATA
		call	EEschre
		call	pause
		
		movlw	.6			;Adressen 5 bis 0 auf Null, Start bei 6
		movwf	Zhler3			;weil bei 0 die Schleife beendet wird

nullen		movf	Zhler3,w
		movwf	Decoderadresse
		decf	Decoderadresse,f	;Zhler minus 1
		movlw	.7
		movwf	Kanalzhler
		movlw	0
		movwf	Eingang
		bcf	Schalter,Datenrichtung
		call	adw
		decfsz	Zhler3,f
		goto	nullen

		bcf	PORTA,ProgLED
		goto	init
		return
;*****************************************************************************************************
;Hauptprogramm
;*****************************************************************************************************
init		call	pause
		call	pause
		call	pause
		bsf	STATUS,RP0
		movlw	.255			;
		movwf	TRISB			;RB0-RB7 Eingang
		movlw	b'01111'		;
		movwf	TRISA			;RA0,RA1,RA2 & RA3 Eingang, RA4 Ausgang
		bcf	STATUS,RP0

		clrf	PORTA
		bsf	PORTA,ProgLED
		clrf	PORTB

		movlw	.57
		movwf	Zhler1
		movlw	0E
		movwf	FSR
lschen		clrf	IND
		incf	FSR,f
		decfsz	Zhler1,f
		goto	lschen

ZentraleAus	bcf	STATUS,RP0		;Decoderadresse lesen
		movlw	Adresspeicher
		movwf	EEADR			;
		call	EElesen			;Ergebniss kommt in w zurck
		movwf	Decoderadr
		movwf	ADpuffer
		call	pause			;ca. 0,2 sek Pause

		;bcf	STATUS,RP0		;Decodermodus lesen
		movlw	Modusspeicher
		movwf	EEADR			;
		call	EElesen			;Ergebniss kommt in w zurck
		movwf	Decodermodus
		movwf	MDpuffer
		call	pause			;ca. 0,2 sek Pause

		;bcf	STATUS,RP0		;Rckmeldeadresse lesen
		movlw	Rckmeldespei
		movwf	EEADR			;
		call	EElesen			;Ergebniss kommt in w zurck
		movwf	Rckmeldeadr
		movwf	Rpuffer
		call	pause			;ca. 0,2 sek Pause

		;bcf	STATUS,RP0		;Verzgerungszeit lesen
		movlw	Verzgerspei
		movwf	EEADR			;
		call	EElesen			;Ergebniss kommt in w zurck
		movwf	Verzgerung
		movwf	VZpuffer
		call	pause			;ca. 0,2 sek Pause

		;bcf	STATUS,RP0		;Funktion lesen
		movlw	Funktionspei
		movwf	EEADR			;
		call	EElesen			;Ergebniss kommt in w zurck
		movwf	Funktion
		movwf	FUpuffer
		call	pause			;ca. 0,2 sek Pause
		
		btfsc	Funktion,0		;wenn Bit0 in Funktion 1 dann
		bsf	Schalter,Funktionsdec	;ist Funktionsdecoder
		
		btfsc	Funktion,1		;wenn Bit1 in Funktion 1 dann	
		bsf	Schalter,DoppelFD	;Funktionsdecoder mit 16 Ausgngen

		btfsc	Funktion,2		;wenn Bit2 in Funktion 1 dann
		bsf	Schalter,Ein32		;Melder mit 32 Eingngen

		btfss	Schalter,Funktionsdec	;wenn kein Melder
		goto	Kein_Funktionsd		;keine gespeicherten Ausgnge laden

		;bcf	STATUS,RP0		;??????weiter nach unten?????
		movlw	AusgangsspeiA		;lese den letzten Zustand der AusgngeA
		movwf	EEADR			;
		call	EElesen			;Ergebniss kommt in w zurck
		movwf	Ausgang
		movwf	AusgangA
		call	pause
		;call	pause

		;bcf	STATUS,RP0		;??????weiter nach unten?????
		movlw	AusgangsspeiB		;lese den letzten Zustand der AusgngeB
		movwf	EEADR			;
		call	EElesen			;Ergebniss kommt in w zurck
		movwf	AusgangB
		call	pause
		;call	pause

Kein_Funktionsd	movlw	.255			
		movwf	EEADR
		clrf	Eingang
		clrf	EINpuffer
		
		movlw	.7			;Anfangskanal wird
		movwf	Kanal1			;dann rckwrtsgezhlt
Kanal1ermitteln	movlw	.16			;Kanal aus der Adresse ermitteln
		subwf	Decoderadr,w
		btfss	STATUS,C
		goto	RKanalbeginn		
		decf	Kanal1,f
		movwf	Decoderadr	
		goto	Kanal1ermitteln

RKanalbeginn	btfsc	Schalter,DoppelFD	;wenn 16 Ausgnge
		goto	RKanalbeginn1		;lese 4. Adresse
		btfss	Schalter,Ein32		;wenn 32 Eingnge lese 4. Adresse
		goto	EinZentrale		;sonst gehe zur Abfrage ob Zentrale ein
RKanalbeginn1	movlw	.7			;Anfangskanal wird dann Rckwrtsgezhlt
		movwf	Kanal2			;
RKanalermitteln	movlw	.16			;Kanal aus der Adresse ermitteln
		subwf	Rckmeldeadr,w
		btfss	STATUS,C
		goto	Kanal3beginn
		decf	Kanal2,f
		movwf	Rckmeldeadr	
		goto	RKanalermitteln

Kanal3beginn	btfss	Schalter,Ein32		;wenn 32 Eingnge lese 3. u. 4. Adresse
		goto	EinZentrale		;sonst gehe zur Abfrage ob Zentrale ein
Kanal3beginn1	movlw	.7			;Anfangskanal wird dann Rckwrtsgezhlt
		movwf	Kanal3			;
Kanal3ermitteln	movlw	.16			;Kanal aus der Adresse ermitteln
		subwf	Decodermodus,w
		btfss	STATUS,C
		goto	Kanal4beginn		;Hauptschleife
		decf	Kanal3,f
		movwf	Decodermodus	
		goto	Kanal3ermitteln

Kanal4beginn	movlw	.7			;Anfangskanal wird dann Rckwrtsgezhlt
		movwf	Kanal4			;
Kanal4ermitteln	movlw	.16			;Kanal aus der Adresse ermitteln
		subwf	Verzgerung,w
		btfss	STATUS,C
		goto	EinZentrale		;Hauptschleife
		decf	Kanal4,f
		movwf	Verzgerung	
		goto	Kanal4ermitteln

EinZentrale	movf	Kanal1,w			;Kopiere Kanal in den Kanalzhler
		movwf	Kanalzhler		;
		movf	Decoderadr,w
		movwf	Decoderadresse
		movf	AusgangA,w		;den gespeicherten AusgangA zum bertragen an
		movwf	Eingang			;die Zentrale in den Eingang schreiben
		bcf	Schalter,Datenrichtung	;auf Daten schreiben schalten
		call	adw

		btfsc	Schalter,Progmode
		call	Programmieren

		btfss	Schalter,DoppelFD	;wenn DoppelFD Ausgnge zurck schreiben
		goto 	EinZentrale1		;sonst berspringe den Abschnitt
		movf	Kanal2,w		;Kopiere Kanal in den Kanalzhler
		movwf	Kanalzhler		;
		movf	Rckmeldeadr,w
		movwf	Decoderadresse
		movf	AusgangB,w		;den gespeicherten AusgangB zum bertragen an
		movwf	Eingang			;die Zentrale in den Eingang schreiben
		bcf	Schalter,Datenrichtung	;auf Daten schreiben schalten
		call	adw

EinZentrale1	btfss	Schalter,Zentrale
		goto	EinZentrale		;bis Zentrale eingeschaltet ist


Hauptschleife	movf	Kanal1,w			;Kopiere Kanal
		movwf	Kanalzhler		;in den Kanalzhler
		movf	Decoderadr,w		;Decoderadresse aus Decoderadressenspeicher in
		movwf	Decoderadresse		;Decoderadresse schreiben
		btfss	Schalter,Funktionsdec	;wenn Melder dann
		goto	Melden			;gehe zu Melden
		bsf	Schalter,Datenrichtung	;auf Daten lesen von Zentrale stellen
		goto	Schalten		;und zu Schalten springen

Melden		bcf	Schalter,Datenrichtung	;auf Daten schreiben zur Zentrale stellen
		
		btfsc	Schalter,Ein32		;wenn 32 Eingnge
		goto	Melden32		;dann gehe zu Melden32
				
		call	Eingabe			;fr Besetztmelder
		btfss	Schalter,Zentrale	;wenn die Zentrale ein
		clrf	Eingang			;berspringe Eingang lschen
		call	adw			;Eingang an Zentrale schreiben		
		goto	Endschleife
		
Melden32	movlw	b'11100111'
		movwf	Einzaehler
		call	ein4fach
		btfss	Schalter,Zentrale	;wenn die Zentrale ein
		clrf	Eingang			;berspringe Eingang lschen
		call	adw			;Eingang an Zentrale schreiben

		movf	Kanal2,w		;Kopiere Kanal
		movwf	Kanalzhler		;in den Kanalzhler
		movf	Rckmeldeadr,w		;Decoderadresse aus Decoderadressenspeicher in
		movwf	Decoderadresse		;Decoderadresse schreiben

		movlw	b'11010111'
		movwf	Einzaehler
		call	ein4fach
		btfss	Schalter,Zentrale	;wenn die Zentrale ein
		clrf	Eingang			;berspringe Eingang lschen
		call	adw			;Eingang an Zentrale schreiben

		movf	Kanal3,w		;Kopiere Kanal
		movwf	Kanalzhler		;in den Kanalzhler
		movf	Decodermodus,w		;Decoderadresse aus Decoderadressenspeicher in
		movwf	Decoderadresse		;Decoderadresse schreiben

		movlw	b'10110111'
		movwf	Einzaehler
		call	ein4fach
		btfss	Schalter,Zentrale	;wenn die Zentrale ein
		clrf	Eingang			;berspringe Eingang lschen
		call	adw			;Eingang an Zentrale schreiben

		movf	Kanal4,w		;Kopiere Kanal
		movwf	Kanalzhler		;in den Kanalzhler
		movf	Verzgerung,w		;Decoderadresse aus Decoderadressenspeicher in
		movwf	Decoderadresse		;Decoderadresse schreiben

		movlw	b'01110111'
		movwf	Einzaehler
		call	ein4fach
		btfss	Schalter,Zentrale	;wenn die Zentrale ein
		clrf	Eingang			;berspringe Eingang lschen
		call	adw			;Eingang an Zentrale schreiben

		goto	Endschleife		;Ausgabe berspringen
Schalten	btfss	Schalter,DoppelFD	
		goto 	Schalten1		;sonst berspringe den Abschnitt

		call	adw			;Leseschleife fr AusgangA

		btfss	Schalter,Zentrale
		goto	ZentraleAus		;nur speichern wenn Zentrale ein

		movf	Ausgang,w		;Schreibe gelesenen Ausgang in Akku
		movwf	DATAUSb			;Schreibe Aukku in Var f. DATAUSb
		call	ausgabe259B		;Ausgang ausgeben

		btfss	Schalter,Zentrale
		goto	Endschleife		;nur speichern wenn Zentrale ein

		bcf	STATUS,RP0
		movlw	AusgangsspeiA
		movwf	EEADR
		movf	Ausgang,w
		movwf	EEDATA
		call	EEschre

		movf	Kanal2,w		;Kopiere Kanal2 in den Kanalzhler
		movwf	Kanalzhler		;
		movf	Rckmeldeadr,w
		movwf	Decoderadresse	
	
		call	adw			;Leseschleife fr AusgangB

		btfss	Schalter,Zentrale
		goto	ZentraleAus		;nur speichern wenn Zentrale ein
		
		movf	Ausgang,w		;Schreibe gelesenen Ausgang in Akku
		movwf	DATAUSa			;Schreibe Aukku in Var f. DATAUSa
		call	ausgabe259A		;Ausgang ausgeben

		btfss	Schalter,Zentrale
		goto	Endschleife		;nur speichern wenn Zentrale ein

		bcf	STATUS,RP0
		movlw	AusgangsspeiB
		movwf	EEADR
		movf	Ausgang,w
		movwf	EEDATA
		call	EEschre

		goto	Endschleife

Schalten1	call	adw			;Leseschleife fr AusgangB
		btfss	Schalter,Zentrale
		goto	ZentraleAus		;nur speichern wenn Zentrale ein
		call	Ausgabe			;fr Funktionsdecoder (Im Ausgang sind Daten)

Endschleife	btfsc	Schalter,Progmode
		call	Programmieren
		goto	Hauptschleife

		end

